<?php $page = "award-ceremony" ?>
<?php include 'links.php'?>
<div class="page">
    <?php include 'header.php'?>
    
    <!-- Section 1: Full Width Banner -->
    <section class="inner-banner">
    <div class="inner-banner-slide">
        <img src="images/slides/venue.jpeg" alt="Event Venue Architect">
        <div class="inner-banner-text">
            <h2>Event Venues</h2>
        </div>
    </div>
</section>
    

    <div class="site-main">

        <section id="about-eventvenue" class="about-eventvenue-section">
            <div class="container">
                <div class="row align-items-center">

      <!-- LEFT CONTENT -->
      <div class="col-lg-8 col-md-8 col-12">
        <div class="about-eventvenue-content">
          <h2 class="about-eventvenue-title">Event Venue Architect</h2>

          <p class="about-eventvenue-text">
            We design purpose-built event venues that blend architectural elegance with functional precision, ensuring every space enhances the guest experience.
          </p>
          <p>
              Our team specialises in creating versatile, aesthetically powerful environments tailored to corporate events, weddings, exhibitions and large-scale gatherings.
          </p>
          <p>
              From concept development to final execution, we craft event spaces that elevate your brand, optimize flow and leave a lasting impression.
          </p>
          
          <p><a href="#" style="display:inline-block; padding:10px 22px; border:2px solid #000; color:#000; text-decoration:none; font-size:16px; font-weight:500; border-radius:4px; background:transparent; ">Contact Us</a>
          </p>
         
        </div>
      </div>

      <!-- RIGHT IMAGE -->
      <div class="col-lg-4 col-md-5 col-12">
        <div class="about-eventvenue-image"></div>
      </div>

            </div>
        </div>
    </section>    
    
     <section id="about-journey" class="about-eventvenue-journey">
  <div class="container">

    <!-- Division 1: Our Approach Intro -->
    <div class="row">
      <div class="col-12">
        <h2>Our Approach</h2>
        
      </div>
    </div>

    <!-- Division 2: Approach Grid -->
    <div class="approach-grid-venue">

      <!-- Row 1 -->
      <div class="approach-item-exih">
        <h3>Concept-Driven Design</h3>
        <p>
         We begin by understanding the vision, purpose and audience of the event venue. Every design concept is crafted to reflect the brand identity, theme and experience you want to deliver, ensuring the space tells a compelling story.
        </p>
      </div>

      <div class="approach-item-venue">
        <h3>Functionality & Flow</h3>
        <p>
          Our designs prioritize seamless movement and usability. From entry points to seating layouts and backstage access, we plan efficient circulation that enhances comfort, accessibility and operational ease for guests and organizers alike. 
        </p>
      </div>

      <div class="approach-item-venue">
        <h3>Technical Integration</h3>
        <p>
          We thoughtfully integrate lighting, acoustics, AV systems and structural requirements into the design. This ensures the venue performs flawlessly during events while maintaining a clean, cohesive aesthetic.
        </p>
      </div>

      <!-- Row 2 -->
      <div class="approach-item-venue">
        <h3>Safety, Compliance & Sustainability</h3>
        <p>
          We adhere to all safety standards, building codes, and crowd management regulations. Wherever possible, we incorporate sustainable materials and energy-efficient solutions to create venues that are responsible, durable, and future-ready.
        </p>
      </div>

    </div>

  </div>
</section>
        
        <section class="gallery-eventvenue-section">
  <div class="gallery-eventvenue-wrapper">
    <img src="images/gallery/pages/venue13.jpeg" alt="Gallery Image 1">
    <img src="images/gallery/pages/venue11.jpeg" alt="Gallery Image 2">
    <img src="images/gallery/pages/venue12.jpeg" alt="Gallery Image 3">
  </div>
</section>
    
    </div><!-- site-main end -->




<?php include 'footer.php'?>
</div>